%%
%reset matlab
clc
clear all
clf


%% Simulate a freely diffusing particle
dt=0.01; %time step
gamma=10;%physical parameters - gamma is friction (kT/gamma = D). 
kT=1;
sdnoise=sqrt(2*dt*kT/gamma); %st. dev. of random noise term added at each step

T=1000; %total time
t=0; %initial time
x=0; %intial position
numsteps=T/dt;



%Run and record trajectory
for i=1:numsteps
    t=t+dt;
    x = x+ normrnd(0,sdnoise);
    tarray(i)=t;
    xarray(i)=x;
end
plot(tarray,xarray);
set(gca, 'FontSize', 20);
hold on
pause(3);

%% Include the force of a harmonic trap on the particle 

%re-initialise poin time and x
x=0;
t=0;

%derivative of potential defined using a function handle
dVdx = @(x) 0.2*x;
%f = @x "some function of x" will calculate the function for you every time
%you type f(x). It also allows you to pass the function to other functions,
%which can be very helpful.


%Run and record trajectory
for i=1:numsteps
    t=t+dt;
    x = x- (1/gamma)* dVdx(x)*dt + normrnd(0,sdnoise);
    tarray(i)=t;
    xarray(i)=x;
end
plot(tarray,xarray);
set(gca, 'FontSize', 20);
pause(3);

